import os
import numpy as np
import pandas as pd

def add_noise_to_R(parent_folder, sigma_r, num_components):
    # Update R_complete.csv in parent folder
    r_complete_path = os.path.join(parent_folder, 'R_complete.csv')
    if os.path.exists(r_complete_path) and os.path.getsize(r_complete_path) > 0:
        R_complete = pd.read_csv(r_complete_path, header=None).values
        D = R_complete.shape[0]
        R_complete_new = R_complete + sigma_r * np.eye(D)
        pd.DataFrame(R_complete_new).to_csv(r_complete_path, header=False, index=False)
        print(f"Updated R_complete.csv with noise (sigma_r={sigma_r})")
    else:
        print("Warning: R_complete.csv is missing or empty.")

    # Update R.csv in each component subfolder
    for i in range(1, num_components + 1):
        r_path = os.path.join(parent_folder, f'C{i}', 'R.csv')
        if os.path.exists(r_path) and os.path.getsize(r_path) > 0:
            R = pd.read_csv(r_path, header=None).values
            d = R.shape[0]
            R_new = R + sigma_r * np.eye(d)
            pd.DataFrame(R_new).to_csv(r_path, header=False, index=False)
            print(f"Updated C{i}/R.csv with noise (sigma_r={sigma_r})")
        else:
            print(f"Warning: C{i}/R.csv is missing or empty.")

# Example usage:
parent_folder = "/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/SWaT/sigma_y_set1/sigma_y_10e1"
sigma_r = 10  # Adjust this value as needed
num_components = 3
add_noise_to_R(parent_folder, sigma_r, num_components)