import pandas as pd

# Path to the data after removing boolean variables
data_path = "/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/train_no_bool_no_p4.csv"

# Read the cleaned data
df = pd.read_csv(data_path)

# Drop clock and label columns
cols = [c for c in df.columns if c not in ('time', 'attack', 'attack_P1', 'attack_P2', 'attack_P3')]

# Identify input columns: all B-tags or tags ending in 'D'
input_cols = [
    c for c in cols
    if c.startswith('P') and (c.split('_')[1].startswith('B') or c.endswith('D'))
]

# Identify output columns: everything else
output_cols = [c for c in cols if c not in input_cols]

# Save input and output data
df[input_cols].to_csv("/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/U_complete.csv", index=False)
df[output_cols].to_csv("/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/Y_complete.csv", index=False)

print("Saved input variables to U_complete.csv and output variables to Y_complete.csv")