import os
import pandas as pd

def trim_data(parent_folder, M, T):
    """
    For each component subfolder (C1, ..., CM) in parent_folder,
    trims Y.csv and U.csv to only keep the first T rows.
    Skips empty files.
    """
    for i in range(1, M + 1):
        subdir = os.path.join(parent_folder, f"C{i}")
        for fname in ["Y.csv", "U.csv"]:
            fpath = os.path.join(subdir, fname)
            if os.path.exists(fpath):
                try:
                    df = pd.read_csv(fpath, header=None)
                except pd.errors.EmptyDataError:
                    # Skip empty files
                    continue
                df_trim = df.iloc[:T, :]
                df_trim.to_csv(fpath, index=False, header=False)
    print(f"Trimmed Y.csv and U.csv to first {T} rows in each C1..C{M} subfolder of {parent_folder}")

# Example usage:
parent_folder = "/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/component_split_trimmed"
M = 3
T = 30000
trim_data(parent_folder, M, T)