# Models Directory

Place your pre-trained models in this directory.

## Required Model

### Qwen2.5-VL-7B-COT-SFT

This is the primary model needed for dual reasoning training. You can obtain it from:

1. **Train your own**: Start with Qwen2.5-VL-7B-Instruct and fine-tune on COT data
2. **Use pre-trained**: Download from [Video-R1 HuggingFace](https://huggingface.co/Video-R1/Qwen2.5-VL-7B-COT-SFT)

### Directory Structure

```
models/
└── Qwen2.5-VL-7B-COT-SFT/
    ├── config.json
    ├── model-*.safetensors
    ├── tokenizer.json
    ├── tokenizer_config.json
    ├── vocab.json
    └── ...
```

## Alternative Models

You can also use other compatible models by updating the `MODEL_PATH` in your configuration:

- `Qwen2.5-VL-7B-Instruct` (base model, requires SFT first)
- `Qwen2.5-VL-14B-Instruct` (larger model, better performance)

## Model Requirements

- **Architecture**: Qwen2.5-VL family
- **Training**: Should be fine-tuned on chain-of-thought data
- **Format**: HuggingFace format with safetensors
- **Size**: Minimum 7B parameters for good performance

## Configuration

Update the model path in `config/dual_reasoning_config.py`:

```python
MODEL_PATH = MODELS_DIR / "Your-Model-Name"
```

Or set environment variable:

```bash
export MODEL_PATH="/path/to/your/model"
```