#!/bin/bash

# Video-R1 Dual Reasoning Setup Script
# This script sets up the environment for dual reasoning training

set -e

echo "🚀 Setting up Video-R1 Dual Reasoning environment..."

# Check if conda is available
if ! command -v conda &> /dev/null; then
    echo "❌ Error: conda is not installed or not in PATH"
    echo "Please install Anaconda or Miniconda first"
    exit 1
fi

# Create conda environment
echo "📦 Creating conda environment..."
conda create -n video-r1-dual python=3.11 -y
echo "✅ Conda environment 'video-r1-dual' created"

echo "📋 To activate the environment, run:"
echo "conda activate video-r1-dual"
echo ""

# Create necessary directories
echo "📁 Creating project directories..."
mkdir -p data models logs config
echo "✅ Project directories created"

# Install Python dependencies
echo "📦 Installing Python dependencies..."
echo "Please activate the conda environment first:"
echo "conda activate video-r1-dual"
echo ""
echo "Then install dependencies with:"
echo "bash setup.sh"
echo ""
echo "And install Qwen video utilities:"
echo "cd src/qwen-vl-utils && pip install -e .[decord] && cd ../.."
echo ""

# Setup instructions
echo "🔧 Setup Instructions:"
echo "1. Place your pre-trained model in: ./models/Qwen2.5-VL-7B-COT-SFT/"
echo "2. Place your training dataset in: ./data/"
echo "3. Configure paths in: ./config/dual_reasoning_config.py"
echo "4. Run training with: bash scripts/run_dual_reasoning.sh"
echo ""

# Environment variable suggestions
echo "🌍 Recommended environment variables:"
echo "export MODEL_PATH=\"$(pwd)/models/Qwen2.5-VL-7B-COT-SFT\""
echo "export DATASET_PATH=\"$(pwd)/data/your_dataset.json\""
echo "export NUM_GPUS=8"
echo "export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7"
echo ""

echo "✅ Setup complete! Follow the instructions above to start training."