cd src/r1-v

export DEBUG_MODE="true" # Enable Debug if you want to see the rollout of model during RL
export LOG_PATH="./debug_log_dual_reasoning.txt"

# For resume training:  --resume_from_checkpoint Model_Path \
# Set dual_reasoning to true to enable the dual reasoning algorithm with shuffled options
# Set use_kl_check to true to add KL consistency regularization (penalizes answer distribution changes due to option shuffling)
# kl_lambda controls the strength of KL consistency regularization (recommended: 0.1-0.5)
work_dir="/scratch/ywxzml3j/ywxzml3juser09/minbin/codes/Video-R1"

# Qwen/Qwen2.5-VL-7B-Instruct
# dataset_name="/mnt/bn/centaurus/code/Video-R1/src/r1-v/Video-R1-data/Video-R1-data/Video-R1-260k_MC_path_replaced.json"
# dataset_name="/mnt/bn/centaurus/code/Video-R1/src/r1-v/Video-R1-data/Video-R1-data/Video-R1-260k_MC_image.json"
# dataset_name="${work_dir}/openr1_4.6k_videor1_mc_image_4.6k.json"
# dataset_name="${work_dir}/openr1_4.6k_videor1_mc_image_4.6k.json"
dataset_name="${work_dir}/LLaVA-Video-large-swift-origin_new_videor1_format_updated_fixed_first_4600.json"

model_name="/scratch/ywxzml3j/ywxzml3juser09/minbin/models/Qwen2.5-VL-7B-COT-SFT"
model_name_abbr="${model_name##*/}"

dataset_name_abbr="${dataset_name##*/}"

CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node="8" \
    --nnodes="1" \
    --node_rank="0" \
    --master_addr="127.0.0.1" \
    --master_port="23456" \
    src/open_r1/grpo.py \
    --output_dir "./log/${model_name_abbr}-shuffle_derangement_DualReasoning_single_reward_1.0_0.7_-0.5_-1.0_${dataset_name_abbr}_bf16_frame_16" \
    --model_name_or_path $model_name \
    --dataset_name $dataset_name \
    --deepspeed "$(pwd)/local_scripts/zero3.json" \
    --max_prompt_length 16384 \
    --max_completion_length 768 \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 1 \
    --learning_rate 1e-6 \
    --lr_scheduler_type "cosine" \
    --weight_decay 0.01 \
    --logging_steps 1 \
    --gradient_checkpointing true \
    --temporal false \
    --bf16 true \
    --len_control true \
    --attn_implementation flash_attention_2 \
    --max_pixels 401408 \
    --num_train_epochs 1 \
    --run_name ${model_name}-shuffle_derangement_DualReasoning_single_reward_1.0_0.7_-0.5_-1.0_${dataset_name_abbr}_bf16_frame_16 \
    --save_steps 200 \
    --beta 0.04 \
    --max_grad_norm 5 \
    --save_only_model true \
    --num_generations 8 \
    --dual_reasoning true \
    --dual_reasoning_reward_list 1.0 0.7 -0.5 -1.0 \
    --use_kl_check false \
    --kl_lambda 0.3 \
    --reward_funcs dual_reasoning format  # Use dual_reasoning reward function 


    # --dataset_name "/mnt/bn/centaurus/code/Video-R1/src/r1-v/Video-R1-data/Video-R1-data/Video-R1-260k_MC_path_replaced.json" \
    # --dataset_name "/mnt/bn/centaurus/code/Video-R1/LLaVA-Video-large-swift-origin_new_videor1_format_updated_fixed_first_4600.json" \
    # --resume_from_checkpoint "./log/Qwen2.5-VL-7B-COT-SFT-GRPO-DualReasoning_single_reward_1.0_0.9_0.3_0.0_${dataset_name_abbr}_bf16_frame_16/checkpoint-650" \
        # --resume_from_checkpoint "./log/Qwen2.5-VL-7B-COT-SFT-GRPO-DualReasoning_single_reward_1.0_0.9_0.1_0.0_${dataset_name_abbr}_bf16_frame_16/checkpoint-300" \
        # --resume_from_checkpoint "./log/Qwen2.5-VL-7B-COT-SFT-GRPO-DualReasoning_single_reward_1.0_0.9_0.1_0.0_${dataset_name_abbr}_bf16_frame_16/checkpoint-300" \
