import os
import zipfile
from multiprocessing import Pool, cpu_count


def _extract_single_zip(zip_path):
    """
    Extract a single zip file into its containing directory.
    """
    print(f"Extracting: {zip_path}")
    try:
        target_dir = os.path.dirname(zip_path)
        with zipfile.ZipFile(zip_path, 'r') as zip_ref:
            zip_ref.extractall(target_dir)
        print(f"Successfully extracted: {zip_path}")
    except Exception as e:
        print(f"Failed to extract {zip_path}: {e}")


def extract_zip_files(root_dir):
    """
    Traverse the specified directory and all its subdirectories,
    and extract all zip files.
    Each zip file will be extracted into its containing directory.
    """
    zip_paths = []
    for dirpath, _, filenames in os.walk(root_dir):
        for filename in filenames:
            if filename.lower().endswith('.zip'):
                zip_paths.append(os.path.join(dirpath, filename))

    if not zip_paths:
        print(f"No zip files found under: {root_dir}")
        return

    process_count = min(cpu_count(), len(zip_paths))
    print(f"Found {len(zip_paths)} zip files. Using {process_count} processes.")

    with Pool(processes=process_count) as pool:
        pool.map(_extract_single_zip, zip_paths)


if __name__ == '__main__':
    root_directory = "./src/r1-v/Video-R1-data"
    extract_zip_files(root_directory)
