# Unlearn vs Sparse

## Pruning

<!-- sparsity 0.9 - 0.95 -->
<!-- synflow first -->

### OMP

```python -u main_imp.py --data ./data --dataset $data --arch $arch --prune_type rewind_lt --rewind_epoch 8 --save_dir ${save_dir} --rate ${rate} --pruning_times 2 --num_workers 8```

### IMP

```python -u main_imp.py --data ./data --dataset $data --arch $arch --prune_type rewind_lt --rewind_epoch 8 --save_dir ${save_dir} --rate 0.2 --pruning_times ${pruning_times} --num_workers 8```

### SynFlow

```python -u main_synflow.py --data ./data --dataset cifar10 --prune_type rewind_lt --rewind_epoch 8 --save_dir ${save_dir} --rate ${rate} --pruning_times 1 --num_workers 8```

## Unlearning

### Retrain

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn retrain --num_indexes_to_replace 4500 --unlearn_epochs 160 --unlearn_lr 0.1```

### FT

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn FT --num_indexes_to_replace 4500 --unlearn_lr 0.01 --unlearn_epochs 10```

### GA

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn GA --num_indexes_to_replace 4500 --unlearn_lr 0.0001 --unlearn_epochs 5```

### FF

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn fisher_new --num_indexes_to_replace 4500 --alpha ${alpha}```

### IU

<!-- tune alpha small sparse model alpha, big dense model alpha 0.1~20 -->

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn wfisher --num_indexes_to_replace 4500 --alpha ${alpha}```

### l1-sparse

<!-- mask load dense model -->

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn FT_prune --num_indexes_to_replace 4500 --alpha ${alpha} --unlearn_lr 0.01 --unlearn_epochs 10```

### AO-sparse

```python -u main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn FT_prune_bi --num_indexes_to_replace 4500 --unlearn_lr 0.01 --unlearn_epochs 10```

## Trojan model cleanse

```python -u main_backdoor.py --save_dir ${save_dir} --mask ${mask_path} --unlearn FT --num_indexes_to_replace 4500```

## FT

```python main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn fisher_new --forgetting_mode {one_class, one_class_random, random} --dataset {cifar10, cifar100, cifar100-20, svhn} --alpha ${alpha} --seed {2, 10, 100, -1}```

## GA

```python main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn wfisher --forgetting_mode {one_class, one_class_random, random} --dataset {cifar10, cifar100, cifar100-20, svhn} --alpha ${alpha} --seed {2, 10, 100, -1}```

-1 stands for the running the 3 seeds sequentially.

## NLS-GA+

```python main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn fisher_new --forgetting_mode {one_class, one_class_random, random} --dataset {cifar10, cifar100, cifar100-20, svhn} --alpha ${alpha} --seed {2, 10, 100, -1} --p [0, 1] --smooth_rate [-\infty, 1]```

## NLS-GA

```python main_forget.py --save_dir ${save_dir} --mask ${mask_path} --unlearn wfisher --forgetting_mode {one_class, one_class_random, random} --dataset {cifar10, cifar100, cifar100-20, svhn} --alpha ${alpha} --seed {2, 10, 100, -1} --p [0, 1] --smooth_rate [-\infty, 1]```