# ChatRearrange: Learning Text-guided 3D Scene Rearrangement

This repository contains the source code and sample data for the paper:

**ChatRearrange: Learning Text-guided 3D Scene Rearrangement**

## Installation & Dependencies

### 1. Create the Environment
You can create a conda environment using the provided `environment.yml` file:
```
conda env create -f environment.yml
conda activate chatrearrange
```

### 2. Compile the Extension Modules
Compile the extension modules as follows:
```
python setup.py build_ext --inplace
pip install -e .
```

## Dataset Generation
For dataset generation and other operations, first change the directory under the `scripts` directory. 

To run each scripts correctly, please change the path in the scripts accordingly.

Afterward, generate the `.pkl` using the following command: 

```
cd scripts
bash scripts/pickle_dataset.sh
```

Then, generate the dataset with LLM-based natural text prompt using as follows: 

```
bash scripts/gen_pyg_full_llm.sh
```

## Training the Model
To train the model, run the following scripts:

```
bash scripts/train.sh
```

## Testing the Model
To test the model, please use the following scripts: 
```
bash scripts/test_all.sh
```