#!/bin/bash
# wandb offline
# export WANDB_MODE=offline
# export FFMPEG_LOG_LEVEL=debug

TIME=$(date "+%Y%m%d%H%M%S")

DATASET_NAME=bed_V2

python train.py \
    --exp_name train_${DATASET_NAME}_w_lg_bert_384_$TIME \
    --dataset_dir ../dataset/$DATASET_NAME \
    --text_cache_dir ../dataset/$DATASET_NAME/text_cache \
    --batch_size 16 \
    --val_batch_size 4 \
    --num_workers 8 \
    --val_every 100 \
    --epochs 3000 \
    --text_emb_model_id bert-base-uncased \
    --print_every_iter 100 \
    --save_every_epoch 25 \
    --text_feat_len 384 \
    --model3d_base_dir ../3d_front_unzip/3D-FUTURE-model \
    --only_last_frame \
    --label_guidance

