#!/usr/bin/env python3
import subprocess

PRUNERS =  ["random", "magnitude", "magnitude_ste", "saliency", "no_prune"]
PCTS = [0.3, 0.5, 0.7, 0.8, 0.85, 0.9, 0.95, 0.98]

def main():
    for pruner in PRUNERS:
        for pct in PCTS:
            print(f"\n=== Running with pruner: {pruner}, prune %: {pct} ===\n")
            cmd = [
                "python", "pipeline.py",
                "--env-name", "hopper",
                "--num-seeds", "5",
                "--algo", "PPO",
                "--arch", "rnn",
                "--use-pruning",
                "--pruner-type", pruner,
                "--prune-percentage", str(pct),
                "--num-minibatches","4"
            ]
            subprocess.run(cmd, check=True)

if __name__ == "__main__":
    main()
