from file_utils import read_file_in_dir
from mains.exp1_pico import exp1_pico_main
from mains.exp1_ops import exp1_ops_main
from mains.exp1_lfw import exp1_lfw_main
from mains.exp2 import exp2_main


if __name__ == '__main__':
    """
    Main entry point
    """
    args = read_file_in_dir('configs.json')

    if args['experiment'] == 1:
        if args['dataset'] == 'pico_mnist':
            exp1_pico_main(args=args)
        elif args['dataset'] == 'noisy_ops':
            exp1_ops_main(args=args)
        elif args['dataset'] == 'lfw':
            exp1_lfw_main(args=args)
        else:
            raise NotImplementedError('Valid dataset names are [\'pico_mnist\', \'noisy_ops\', \'lfw\']')

    elif args['experiment'] == 2:
        exp2_main(args=args)
    
    else:
        raise NotImplementedError('Valid experiment numbers are [1,2]')
