# Degeneration and Neural Plasticity

We provide code for introducing focal damage to CORnet-S. This code can very easily be adapted to other model architecture classes and damage levels.

`CORnet-S` has four defined areas inspired from the biological ventral visual stream: `V1`, `V2`, `V4`, and `IT`. To lesion one of these regions, use the following code:

```python
import torch
import torch.nn as nn
from torch.nn.utils import prune


model = CORnet_S()

regions = [model.V1, model.V2, model.V4, model.IT]
region_to_be_lesioned = 1  # [0, 1, 2, 3]
region = regions[region_to_be_lesioned]

conv_layers = [module for module in region.modules() if isinstance(module, nn.Conv2d)]

for lesion_iter in range(40):  # how many times to iteratively introduce lesions
    for x in conv_layers:
        prune.random_unstructured(x, name='weight', amount=0.2)
```

To run the experiments from the paper, update `config.json` with the required arguments and then call

```bash
python3 run.py
```