#!/bin/bash

deepspeed llava/train/train_sparse.py \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path [llava-v1.5-7b] \
    --version v1 \
    --data_path [./playground/data/llava_v1_5_mix665k.json] \
    --image_folder [./playground/data] \
    --vision_tower openai/clip-vit-large-patch14-336 \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length False \
    --requires_image True \
    --bf16 True \
    --output_dir ./results/dynamic-llava-7b \
    --num_train_epochs 1.0 \
    --per_device_train_batch_size 8 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 40000 \
    --save_total_limit 1 \
    --learning_rate 5e-6 \
    --weight_decay 0. \
    --predictor_lr 2e-4 \
    --predictor_weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb \
    --mask_loss_weight 100.0 \
    --gumbel_start_tau 1.0 \
    --gumbel_end_tau 0.1 \
    --use_vision_predictor True \
    --use_text_predictor True \
    --use_output_text_predictor True \
    --use_instruct_predictor False \
    --vision_keep_rate 0.2 \
    --output_text_keep_rate 0.5 \
    --output_text_len_for_training 50 \
