import numpy as np
import pandas as pd

from util import load_data, calc_acc_auc, dmg_data, adjust_proba
from methods import ORG, Sur_Ens, Smote, UnderSample, Ensemble
import warnings
from sklearn.model_selection import train_test_split

warnings.filterwarnings('ignore')
pd.set_option('display.max_columns', None)
pd.set_option('display.expand_frame_repr', False)


dmg_dic = {'kr_vs_kp':'X_c31', 'cancer':'X24', 'twonorm':'X_A13', 'ring':'X_A1', 'chess':'X_A20', 'women_bank':'XT1_wFinlit'}
#dmg_dic = {'kr_vs_kp':'X_c15', 'cancer':'X23', 'twonorm':'X_A18', 'ring':'X_A13', 'chess':'X_A30', 'women_bank':'XT2_wFinlit'}
#dmg_dic = {'kr_vs_kp':'X_c22', 'cancer':'X14', 'twonorm':'X_A6', 'ring':'X_A14', 'chess':'X_A25', 'women_bank':'XCONT_cl_age_female'}
#dmg_dic = {'kr_vs_kp':'X_c21', 'cancer':'X26', 'twonorm':'X_A1', 'ring':'X_A5', 'chess':'X_A14', 'women_bank':'XGPCONT_c_GHOST'}
#dmg_dic = {'kr_vs_kp':'X_c26', 'cancer':'X11', 'twonorm':'X_A20', 'ring':'X_A12', 'chess':'X_A21', 'women_bank':'XGPCONT_c_sarpanch_sc'}

file_names = ['kr_vs_kp', 'cancer', 'twonorm', 'ring', 'chess', 'women_bank']

file_names = [file_names[5]]

models = ['lr', 'svm', 'rf', 'nn', 'xgb']

dmg_typ = 'left'   #rnd:random (MAR), left or right: based on ascending or descending X values (MNAR)


rands = np.arange(0, 10, 1)     #Tests are averaged over 10 random rounds


finetune = 0                    #whether to perform threshold tuning
dmgeval = 0                     #whether test set is sampled from imbalanced dataset (biases evaluation)
varyperc = 0                    #whether to vary the imbalance percentage

appr = ['GLD', 'DMG', 'WGT', 'ENS', 'ENSC', 'ENS_EKR', 'CLCNT', 'Tomek', 'EasyEns', 'BalBag', 'SMT', 'SMTBORD', 'SMTASD'] #imbalance methods: Gold UB, Damaged LB, reweighting, RBE, CBE, EKR, CC, TMK, EE, BB, SMT, B-SMT, ADSN


ind = []
for i in appr:
    for k in rands:
        ind += [i + ' ' + str(k)]



x_train, y_train, _, _, _, _ = load_data("../data/" + file_names[0] +'.csv', rnd = 0)
fold = "../results/"

if finetune == 1:
    fold += "finetune/"
if dmgeval == 1:
    fold += "dmgeval/"
if varyperc == 1:
    fold += "varied/"


dmg_spc = dmg_dic[file_names[0]]  #Which X to use for MNAR


num_vars = 0
for c in x_train.columns:
    if isinstance(c, str) and c[0] == 'X':
        num_vars += 1
        

if dmg_typ == 'left':           #MNAR is simulated by removing larger values of X, if LR coefficient is nonnegative, and lower values of X otherwise
    
    mod = ORG(x_train, y_train)
    if mod.coef_[0][x_train.columns.get_loc(dmg_spc)] < 0:
        dmg_typ = 'right'

    
print(dmg_typ, dmg_spc)          


percents = [0.95]                                   #Damage percentage (how much of positive class to delete) causing imbalance. 95% is used for main results

if varyperc == 1:
    percents = np.arange(0.65, 1, 0.1).round(2)         #varying damage percentage
if dmgeval == 1:
    percents = [0.85]                                   #damage percentage for biased evaluation. 0.85 is used to provide sufficient data when sampling the test set from the damaged imbalanced data

    
fin_cols_acc = []
for perc in percents:
    fin_cols_acc += [str(round(perc*100))] 

            
for met_typ in models:
    
    if met_typ == 'svm' or met_typ == 'nn':         #Data is normalized for MLP or SVM, but not required for RF or LR
        scaled = 1
    else:
        scaled = 0
    
    print(met_typ)
                
    for file_name in file_names:
        
        print(file_name)
        
        acc = pd.DataFrame(0, columns=fin_cols_acc, index = appr)           #balanced accuracy
        prc = pd.DataFrame(0, columns=fin_cols_acc, index = appr)           #precision
        rec = pd.DataFrame(0, columns=fin_cols_acc, index = appr)           #recall
        auc_roc = pd.DataFrame(0, columns=fin_cols_acc, index = appr)       #ROC AUC
        auc_prc = pd.DataFrame(0, columns=fin_cols_acc, index = appr)       #PR AUC
        f1 = pd.DataFrame(0, columns=fin_cols_acc, index = appr)            #F1

        acc_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)
        prc_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)
        rec_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)
        aucroc_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)
        aucprc_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)
        f1_f = pd.DataFrame(0, columns=fin_cols_acc, index = appr)

                            
        for rnd in rands:
            print('\nrnd', rnd)
            np.random.seed(rnd)
        
            if dmgeval == 1:
                x_train, y_train, _,_, x_org, y_org = load_data("../data/" + file_name +'.csv', rnd = rnd, scale = scaled)
            else:
                x_train, y_train, x_test, y_test, x_org, y_org = load_data("../data/" + file_name +'.csv', rnd = rnd, test_s = 0.2, scale = scaled)     #load data
            
            tc = len(percents)
            dmg = 0
            for pp in range(len(percents)):
                
                col_acc = fin_cols_acc[pp]

                print('\nperc', percents[pp])
                

                print('Gold, ', end = "")
                cmet = 'GLD'

                mod = ORG(x_train, y_train, mod_typ = met_typ) 
                
                if finetune == 1:                            
                    acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], y_train, mod.predict_proba(x_train)[:, 1])
                else:
                    acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

                gold_prob = mod.predict_proba(x_train)[:, 1]
                

                
                if pp == 0:
                    if dmg_typ == 'left' or dmg_typ == 'right':
                        by_tr = x_train.loc[:, dmg_spc]
                        by_ts = x_test.loc[:, dmg_spc]
                    else:
                        by_tr = []
                        by_ts = []
                        
                
                df_temp = x_test.copy()
                df_temp['y'] = y_test
                x_test_rem = dmg_data(df_temp, percents[pp], dmg_typ, by_ts, rnd = rnd)
                idx_rem = x_test_rem.index
                idx_del = x_test.index.difference(x_test_rem.index)
                idx_del = np.concatenate([idx_del, x_test.loc[df_temp.y == 0].index])


                df_temp = x_train.copy()
                df_temp['y'] = y_train
                
                df_dmg = dmg_data(df_temp, percents[pp], dmg_typ, by_tr, rnd = rnd)            #simulating MAR or MNAR
                    
                ydmg = df_dmg.y
                xdmg = df_dmg.drop(labels = 'y', axis = 1)
                
                if dmgeval == 1:
                    xdmg, x_test, ydmg, y_test = train_test_split(xdmg, ydmg, test_size = 0.6, random_state = rnd)      #test set is sampled from damaged dataset. 0.6 is selected to result in approximately 0.95 damage in minority class and match original experiments
                    print('fin dmg prc: ', 1 - ydmg.sum() / y_org.sum())
                
                xdmg_ns = x_org.loc[xdmg.index, :]                                          #original non-normalized X for K-means algorithm
                                    
                
                print('dmg, ', end = "")
                cmet = 'DMG'
                
                mod = ORG(xdmg, ydmg, mod_typ = met_typ)
                
                if finetune == 1:                            
                    acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                else:
                    acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

            
                if 'WGT' in appr: 
                    cmet = 'WGT'
                    print('reweight, ', end = "")
                    mod = ORG(xdmg, ydmg, reweight = 1, mod_typ = met_typ)
                    
                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])
                
                if 'FOC' in appr: 
                    cmet = 'FOC'
                    print('focal, ', end = "")
                    mod = ORG(xdmg, ydmg, reweight = 'focal', mod_typ = met_typ)
                    
                    for cc, ww in zip(['','rem','del'], [x_test.index, idx_rem, idx_del]):
                        if finetune == 1:                            
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc] = calc_acc_auc(y_test.loc[ww], mod.predict_proba(x_test.loc[ww, :])[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                        else:
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc] = calc_acc_auc(y_test.loc[ww], mod.predict_proba(x_test.loc[ww, :])[:, 1])

                                        
                if 'CLS' in appr: 
                    cmet = 'CLS'
                    print('class-balanced weight, ', end = "")
                    mod = ORG(xdmg, ydmg, reweight = 'class', mod_typ = met_typ)
                    
                    for cc, ww in zip(['','rem','del'], [x_test.index, idx_rem, idx_del]):
                        if finetune == 1:                            
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc] = calc_acc_auc(y_test.loc[ww], mod.predict_proba(x_test.loc[ww, :])[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                        else:
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc] = calc_acc_auc(y_test.loc[ww], mod.predict_proba(x_test.loc[ww, :])[:, 1])
                        

                if 'DEB' in appr: 
                    cmet = 'DEB'
                    
                    mod = ORG(xdmg, ydmg, mod_typ = met_typ)
                    
                    proba_train = pd.Series(adjust_proba(mod.predict_proba(xdmg)[:, 1], ydmg), index = xdmg.index)
                    proba_test = pd.Series(adjust_proba(mod.predict_proba(x_test)[:, 1], ydmg), index = x_test.index)
                    
                    for cc, ww in zip(['','rem','del'], [x_test.index, idx_rem, idx_del]):
                        if finetune == 1:                            
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc] = calc_acc_auc(y_test.loc[ww], proba_test.loc[ww], ydmg, proba_train)
                        else:
                            acc.loc[cmet, col_acc + cc], auc_roc.loc[cmet, col_acc + cc], auc_prc.loc[cmet, col_acc + cc], prc.loc[cmet, col_acc + cc], rec.loc[cmet, col_acc + cc], f1.loc[cmet, col_acc + cc]= calc_acc_auc(y_test.loc[ww], proba_test.loc[ww])
                            

                    
                if 'ENS' in appr: 
                    cmet = 'ENS'
                    print('ens, ', end = "")
                    
                    proba_train, proba_test = Sur_Ens(xdmg, ydmg, x_test, y_test, xdmg_ns, clust = 0, mod_typ = met_typ)

                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, proba_test, ydmg, proba_train)
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc]= calc_acc_auc(y_test, proba_test)

                    
                if 'ENSC' in appr:  
                    cmet = 'ENSC'
                    print('ens clust, ', end = "")
                    
                    proba_train, proba_test = Sur_Ens(xdmg, ydmg, x_test, y_test, xdmg_ns, clust = 1, mod_typ = met_typ)

                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, proba_test, ydmg, proba_train)
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc]= calc_acc_auc(y_test, proba_test)

                    

                if 'CLCNT' in appr:
                    cmet = 'CLCNT'
                    print('cluster center, ', end = "")                
                    
                    mod, xs, ys = UnderSample(xdmg, ydmg, ver = 'clust', mod_typ = met_typ)
                    
                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

                
                if 'Tomek' in appr:
                    cmet = 'Tomek'
                    print('Tomek, ', end = "")                
                    
                    mod, xs, ys = UnderSample(xdmg, ydmg, ver = 'tomek', mod_typ = met_typ)
                    
                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

            
                    
                if 'ENS_EKR' in appr:  
                    cmet = 'ENS_EKR'
                    print('ens EKR, ', end = "")
                    
                    proba_train, proba_test = Sur_Ens(xdmg, ydmg, x_test, y_test, xdmg_ns, clust = 'ekr', mod_typ = met_typ)
                    
                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, proba_test, ydmg, proba_train)
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc]= calc_acc_auc(y_test, proba_test)
                
                
                if 'EasyEns' in appr:
                    cmet = 'EasyEns'
                    print('easy ens, ', end = "")
                
                    mod = Ensemble(xdmg, ydmg, ver = 'easy', mod_typ = met_typ)
                    
                    if finetune == 1:                                                    
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

                if 'BalBag' in appr:
                    cmet = 'BalBag'
                    print('balanced bag, ', end = "")
                
                    mod = Ensemble(xdmg, ydmg, ver = 'bag', mod_typ = met_typ)
                    
                    if finetune == 1:                                                    
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])


                if 'SMT' in appr:
                    cmet = 'SMT'
                    print('smote, ', end = "")                
                    
                    mod, xs, ys = Smote(xdmg, ydmg, mod_typ = met_typ)
                    
                    if finetune == 1:                            
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                    else:
                        acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])
                
                
                if 'SMTBORD' in appr:
                    cmet = 'SMTBORD'
                    try:
                        print('bord smote, ', end = "")
                        mod, xs, ys = Smote(xdmg, ydmg, ver = 'bord', mod_typ = met_typ) 
                        
                        if finetune == 1:                            
                            acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                        else:
                            acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

                    except:
                        pass
                
                if 'SMTASD' in appr:
                    cmet = 'SMTASD'
                    try:
                        print('asd smote, ', end = "")
                        mod, xs, ys = Smote(xdmg, ydmg, ver = 'asd', mod_typ = met_typ) 
                        
                        if finetune == 1:                            
                            acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1], ydmg, mod.predict_proba(xdmg)[:, 1])
                        else:
                            acc.loc[cmet, col_acc], auc_roc.loc[cmet, col_acc], auc_prc.loc[cmet, col_acc], prc.loc[cmet, col_acc], rec.loc[cmet, col_acc], f1.loc[cmet, col_acc] = calc_acc_auc(y_test, mod.predict_proba(x_test)[:, 1])

                    except:
                        pass
                    
 

            acc_f += acc / len(rands)
            aucroc_f += auc_roc / len(rands)
            aucprc_f += auc_prc / len(rands)
            prc_f += prc / len(rands)
            rec_f += rec / len(rands)
            f1_f += f1 / len(rands)




    
        
    file_name = file_name + '_' + dmg_typ + '_' + str(dmg_spc)

    acc_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_acc.csv')
    aucroc_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_rocauc.csv')
    aucprc_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_prauc.csv')
    prc_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_prc.csv')
    rec_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_rec.csv')
    f1_f.to_csv(path_or_buf = fold + '/' + met_typ + '/' + file_name + '_f1.csv')

    print("")
    print('acc\n', acc_f)
    print('auc_roc\n', aucroc_f)
    print('auc_prc\n', aucprc_f)
    print('prc\n', prc_f)
    print('rec\n', rec_f)
    print('f1\n', f1_f)
    




   