## Overview

This repository provides the official PyTorch implementation for the submission "Goal-Oriented Sequential Bayesian Experimental Design for Causal Learning". We present code to reproduce the experiments for:

1.  **Causal Reasoning with Targeted Queries:** 
2.  **Causal Discovery (Linear and nonlinear SCMs)**

## Environment Setup
To ensure reproducibility, we recommend setting up the Python environment using Conda:

1.  **Create a Conda environment:**
    ```bash
    conda create -n gocbed_env python=3.10
    conda activate gocbed_env
    ```
2.  **Install dependencies:**
    ```bash
    pip install -r requirements.txt
    ```

## Running Experiments

### 1. Causal Reasoning with Targeted Queries

**Example Command:**
```bash
python train_goal_policy.py --env er --n_nodes 10 --n_stage 10 --edge_prob 0.2 --do_node 5 --goal_nodes [0,1] --do_mean 6 --do_std 0.5 --n_int 3 --n_obs 30 --posterior_data_dir data/Nonlinear_ER_data --num_steps 10001
```

**To see all options:**
```bash
python train_goal_policy.py -h
```

### 2. Causal Discovery

#### i. Linear SCMs

**Example Command:**
```bash
python train_csl_linear.py --env er --n_nodes 10 --edge_prob 0.2 --n_stage 10 --n_int 3 --n_obs 30 --save_every 500 --num_steps 10001
```

**To see all options:**
```bash
python train_csl_linear.py -h
```

#### ii. Nonlinear SCMs

**Example Command:**

```bash
python train_csl_nonlinear.py --env er --n_nodes 10 --n_stage 10 --edge_prob 0.2 --n_int 3 --n_obs 30 --num_steps 10001
```

**To see all options:**
```bash
python train_csl_nonlinear.py -h
```

For parts of the synthetic data generation process, our implementation adapts components from the framework presented in AVICI (Lorch et al., 2022).