from .random import random_method
from .confidence import confidence
from .uncertainty import uncertainty
from .most_draws import most_draws
from .llm_selector import llm_selector
from .bradley_terry import bradley_terry

all_methods = {
    "random": random_method,
    "confidence": confidence,
    "uncertainty": uncertainty,
    "most_draws": most_draws,
    "llm_selector": llm_selector,
    "bradley_terry": bradley_terry
}

__all__ = [
    "random_method",
    "confidence",
    "uncertainty",
    "most_draws",
    "llm_selector",
    "bradley_terry",
    "all_methods"
]