"""
Script for selective plotting after running the main script.
"""
import json
from pathlib import Path
import matplotlib.pyplot as plt


data_path = "bigcodebench" # options: ["alpacaeval","arena-hard","mt-bench","bigcodebench"]

def plot_results(random_results, confidence_results, uncertainty_results, most_draws_results, llm_selector_results, llm_selector_label, save_path=f'{data_path}/identification_prob.png'):
    plt.plot(random_results, label='random')
    plt.plot(confidence_results, label='confidence')
    plt.plot(uncertainty_results, label='uncertainty')
    plt.plot(most_draws_results, label='most_draws')
    plt.plot(llm_selector_results, label=llm_selector_label)
    plt.ylim((-0.01,1.01))
    plt.xlabel('budget')
    plt.ylabel('identification prob')
    plt.legend()
    plt.savefig(save_path)
    

if __name__ == "__main__":
    # Load results from the specified data path
    path = Path(f"{data_path}/results.json")
    
    with path.open(encoding="utf-8") as f:  # never forget the encoding!
        data = json.load(f) 
    
    random_results = data.get("random", [])
    confidence_results = data.get("confidence", [])
    uncertainty_results = data.get("uncertainty", [])
    most_draws_results = data.get("most_draws", [])
    
    best_llm_selector_label = "llm_selector (eps=(0.3, 0.3))"
    llm_selector_results = data.get(best_llm_selector_label, [])
    
    # Call the plotting function with the loaded results
    plot_results(random_results, confidence_results, uncertainty_results, most_draws_results, llm_selector_results, llm_selector_label=best_llm_selector_label, save_path=f'{data_path}/identification_prob_best_llmsel.png')
    
    print(f"Results plotted for {data_path}.")
