%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SETUP

clearvars;
addpath('~/Documents/MATLAB/cvx'); % directory where CVX is installed
cvx_setup;                         % if first time
format compact;
tStart = tic;
clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIRECTORIES

wd = pwd;                                        % working directory
id = '../../../Datasets/Handwriting/infimnist';  % infimnist directory
addpath(wd);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONSTANTS

numPixels = 784;
numWindows = 10;
windowSize = 50000;
numExample = numWindows * windowSize;
maxY = 10;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SEPARATE

X = zeros(numPixels,numExample);
Y = zeros(1,numExample);
separable = zeros(numWindows,maxY,maxY);
for window=1:numWindows
  fprintf(1,'%d examples:\n',window*windowSize);
  fprintf(1,'  pair  separable?\n');
  % GENERATE WINDOW
  tBatch = tic;
  idxA = 10000 + (window-1)*windowSize;
  idxB = idxA + windowSize - 1;
  fileL = sprintf('labels_%04d.dat',window);
  fileP = sprintf('patterns_%04d.dat',window);
  commandL = sprintf('./infimnist lab %d %d > %s/%s',idxA,idxB,wd,fileL);
  commandP = sprintf('./infimnist pat %d %d > %s/%s',idxA,idxB,wd,fileP);
  cd(id); system(commandL); system(commandP); cd(wd);
  [Xw,Yw] = load_mnist(fileP,fileL,0);
  delete(fileL);
  delete(fileP);
  X(:,(window-1)*windowSize+1:window*windowSize) = Xw;
  Y((window-1)*windowSize+1:window*windowSize) = Yw;
  for c1=1:maxY-1
    X1 = X(:,Y==c1);
    Y1 = ones(1,size(X1,2));
    for c2=c1+1:maxY
      fprintf(1,'  [%dv%d]',c1,mod(c2,maxY));
      if (window>1)
        if (separable(window-1,c1,c2)==0)
          fprintf(1,'   NO\n');
          continue;
        end
      end
      X2 = X(:,Y==c2);   
      Y2 = -ones(1,size(X2,2));
      tic;
      [~,~,margin] = linear_max_margin([X1 X2],[Y1 Y2]);
      if (margin==0)
        fprintf(1,'   NO');
      else
        separable(window,c1,c2) = 1;
        separable(window,c2,c1) = 1;
        fprintf(1,'  YES');
      end
      fprintf(1,'  (%.1f sec)\n',toc)
    end
  end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

