%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [patterns,labels] = ...
  load_mnist(filename_patterns,filename_labels,addOffset)

% loads MNIST image patterns
% rescales pixel values to lie between 0 and 1
% converts labels=0 to labels=10 for matlab indexing
% adds extra +1 element if addOffset==1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% CONSTANTS
headerL = 8; 
headerP = 16; 
maxVal = 255;
d = 784;

% LABELS
fid = fopen(filename_labels,'r');
fread(fid,headerL,'uchar');
labels = fread(fid,inf,'uchar');
n = length(labels);
labels = reshape(labels,1,n);
labels(labels==0) = 10;
fclose(fid);

% PATTERNS
patterns = zeros(d,n);
fid = fopen(filename_patterns,'r','b');
fread(fid,headerP,'uchar');
for t=1:length(labels)
  img = fread(fid,d,'uchar');
  patterns(:,t) = img(:)/maxVal;
end
fclose(fid);

% OFFSET
if (addOffset==1)
  patterns = [patterns; ones(1,n)];
end
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



