function [U_align,V_align] = align_lorentz(U,V)

% SOLVE FOR MINIMUM NORM BOOST
uv = U(:)'*V(:);
uu = U(:)'*U(:);
vv = V(:)'*V(:);
phi = 0.5 * atanh(2*uv/(uu+vv));

% LORENTZ TRANSFORMATION
U_align = U*cosh(phi) - V*sinh(phi);
V_align = V*cosh(phi) - U*sinh(phi);
return;
