function [w,b,margin] = linear_max_margin(X,Y)

% inputs x
% labels y {-1,+1}

% ARGS
[d,n] = size(X);
Y = Y(:)';

% HARD MARGIN
cvx_begin quiet
  cvx_solver sedumi
  variable w(d)
  variable b
  minimize (w'*w)
  subject to
    (w'*X + b).*Y >= 1
cvx_end

% MARGIN
margin = 2/sqrt(cvx_optval); % ZERO IF NOT SEPARABLE
end

%%%%%%%%%%%%%%%%%%%%%%
