# Add context to existing instruction json file

import json
import os
from pathlib import Path
from tqdm import tqdm
from datetime import datetime


split = "train"
input_file = Path(f"/scratch/datasets/MIMIC-CXR/template_instructions_{split}.json")
output_file = Path(f"/scratch/datasets/MIMIC-CXR/classifier_template_instructions_{split}.json")

context_dir = Path(f"/scratch/datasets/MIMIC-CXR/classifier_result")
prompt = " Please refer to the following information: "

with open(input_file) as f:
    output_json = json.load(f)
print(f"Loading input from {str(input_file)}")
output_json["meta"]["time"] = datetime.today().strftime('%Y-%m-%d')
for context_file in tqdm(context_dir.iterdir(), total=len(os.listdir(context_dir))):
    study_id = context_file.stem
    if study_id in output_json["data"].keys():
        with open(context_dir / context_file) as f:
            context = " ".join(f.readlines()).strip().lower()
        output_json["data"][study_id]["instruction"] += prompt + context

print(f"Saving output to {str(output_file)}")
with open(output_file, 'w') as f:
    json.dump(output_json, f, indent=2)