import os
import shutil
from pathlib import Path
from tqdm import tqdm



data_dir = Path("/scratch/datasets/MIMIC-CXR")
file_type = "reports"  # images or reports
study_id_prefix = ("s")
dst_dir = data_dir/file_type
dst_dir = Path("tmp")
data_dir = data_dir/"files"/"reports" if file_type == "reports" else data_dir/"files"


for p in tqdm(data_dir.iterdir(), total=len(os.listdir(data_dir))):
    if p.name.startswith("p1"):
        for patient in tqdm(p.iterdir(), total=len(os.listdir(p))):
            if patient.name.startswith("p1"):
                for study in patient.iterdir():
                    if study.name.startswith(study_id_prefix) and study.name not in os.listdir(dst_dir):
                        if file_type == "images":
                            shutil.copytree(study, dst_dir/study.name)
                        elif file_type == "reports":
                            shutil.copy(study, dst_dir/study.name)

# data_dir = data_dir/"reports_correction"
# for p in tqdm(data_dir.iterdir(), total=len(os.listdir(data_dir))):
#     if p.name.startswith(study_id_prefix) and p.name not in os.listdir(dst_dir):
#         shutil.copy(p, dst_dir)