import os
import sys
import csv
from pathlib import Path
from tqdm import tqdm
from mimic_cxr_utils import create_id2path_dict, parse_report

assert len(sys.argv) == 2
result_dir = Path(sys.argv[1])
preds_csv_path = result_dir / "preds_orig.csv"
gts_csv_path = result_dir / "gts_orig.csv"
data_dir = Path("/data/datasets/MIMIC-CXR/")
id2path = create_id2path_dict(data_dir/"mimic-cxr-2.0.0-metadata.csv")
preds_csv = open(preds_csv_path, 'w')
gts_csv = open(gts_csv_path, 'w')
preds_writer = csv.writer(preds_csv, delimiter=',', quotechar='"', quoting=csv.QUOTE_MINIMAL)
gts_writer = csv.writer(gts_csv, delimiter=',', quotechar='"', quoting=csv.QUOTE_MINIMAL)
for file in tqdm(result_dir.iterdir(), total=len(os.listdir(result_dir))):
    if not file.name.endswith(".txt"): continue
    result_str = ""
    f = open(file, 'r')
    for line in f.readlines():
        line = line.strip('\t ')
        result_str += line
    f.close()
    preds, gts = [], []
    report_path = data_dir / id2path[file.name.replace(".txt", "")]
    gt, _, _ = parse_report(report_path)
    gt = gt.strip("\t\n ")
    if "template" in str(result_dir):
        gt_idx = result_str.find("GT:")
        pred = result_str[:gt_idx].replace("PRED:", "").strip("\n ").replace('\n', ',')
        if len(pred) == 0 or len(gt) == 0: continue
        preds_writer.writerow([pred])
        gts_writer.writerow([gt])
    else:
        raise NotImplementedError

preds_csv.close()
gts_csv.close()

