import csv
import random
import os.path
from pathlib import Path
from enum import Enum, auto
import pandas as pd

from mimic_cxr_utils import remove_leakage


def get_previous_report_id(session_id, patient_data):
    report_row = patient_data[patient_data["session_id"] == session_id].iloc[0]
    current_date = report_row["study_date"]
    previous_date = 0
    previous_report_id = None
    for id, row in patient_data.iterrows():
        if previous_date < row["study_date"] < current_date:
            previous_date = row["study_date"]
            previous_report_id = row["session_id"]
    return previous_report_id
