import shutil
from pathlib import Path
from tqdm import tqdm


data_dir = "/data/datasets/BIMCV-COVID19-cIter_1_2-Negative/"

data_dir = Path(data_dir)
for name in ["pos", "neg"]:
    for sub_dir in tqdm(list((data_dir/f"covid19_{name}").iterdir())):
        if sub_dir.name.startswith("sub"):
            rm_sub_dir = True
            for ses_dir in sub_dir.iterdir():
                if ses_dir.name.startswith("ses"):
                    rm_ses_dir = True
                    if (ses_dir/"mod-rx").is_dir():
                        for img in (ses_dir/"mod-rx").iterdir():
                            if img.name.endswith(".nii.gz"):
                                rm_ses_dir = False
                                rm_sub_dir = False
                                break
                    if rm_ses_dir:
                        shutil.rmtree(ses_dir)
            if rm_sub_dir:
                shutil.rmtree(sub_dir)
                pass
