# PROPGCL

The code is based on the paper [Inductive Representation Learning on Large Graphs](https://arxiv.org/pdf/1706.02216)

## Environment requirement

```bash
absl-py==0.2.2
astor==0.6.2
backports.weakref==1.0.post1
bleach==1.5.0
decorator==4.3.0
enum34==1.1.6
funcsigs==1.0.2
futures==3.2.0
gast==0.2.0
grpcio==1.12.1
html5lib==0.9999999
Markdown==2.6.11
mock==2.0.0
networkx==1.11
numpy==1.14.5
pbr==4.0.4
protobuf==3.6.0
scikit-learn==0.19.1
scipy==1.1.0
six==1.11.0
sklearn==0.0
tensorboard==1.8.0
tensorflow==1.8.0
termcolor==1.1.0
Werkzeug==0.14.1
```

## Running

**Dataset Preparing**
The full Reddit and PPI datasets are available on the [project website](http://snap.stanford.edu/graphsage/). Download the data and save into the path `data/[dataset_name]`

For PROP, you can run with
```bash
python -m graphsage.prop --train_prefix ./data/ppi/ppi --model prop --max_total_steps 1000 --validate_iter 10
```

For GRACE, you can run with

```bash
python -m graphsage.unsupervised_train --train_prefix ./data/ppi/ppi --model graphsage_mean --max_total_steps 1000 --validate_iter 10
```
