# PROPGCL

Code for paper *PROPGCL: Unleashing the Power of Propagation in Graph Contrastive Learning*

## Introduction

We organize our code in the following structure. The main directory includes `node_classification` and `graph_classification` sub-directories. For `node_classification`, we implement diverse GCL methods in unified pretraining-evaluation framework, including DeepWalk, Node2Vec, GRACE, DGI, GAE, VGAE, MVGRL, CCA-SSG, BGRL, GCA, ProGCL, PolyGCL, SP-GCL, HGRL, GraphACL, DSSL, and our approaches PROP-GRACE, PROP-DGI, and PROP. For the new heterophily datasets proposed by [this paper](https://arxiv.org/abs/2302.11640), we include implementation in the directory `HeterophiliousGraph`. For large graph including ogbn-arxiv and ogbn-products, we include implementations in the directory `LargeGraph`. For inductive settings, we include implementations in `Inductive`. For `graph_classification`, we implement GCL methods including GL, WL, DGK, node2vec, sub2vec, graph2vec, MVGRL, InfoGraph, GraphCL, JOAOv2, and ADGCL. See `README.md` file for detailed instructions.

## Environment requirement

```bash
alive-progress==3.1.5 
cudatoolkit==11.3.1
dgl-cu113==0.9.1.post1
matplotlib==3.7.1
networkx==3.2.1
numpy==1.20.3
ogb==1.3.6
python==3.9.19
pytorch==1.11.0
scikit-learn==0.24.2
scipy==1.8.0
torch-cluster==1.6.0
torch-geometric==1.7.2
torch-scatter==2.0.9
torch-sparse==0.6.13
torchmetrics==0.9.2
tqdm==4.66.2
```

## Running

For PROP, you can run `prop.py` by assigning the `--K` argument with different propagation steps. For example,

```bash
python prop.py --dataset Cora --K 1
```

For PROP-GRACE, you can run  `grace.py` by assigning the `--net` argument with names in [`PropChebNetII`, `PropBernNet`, `PropGPRGNN`]. For example,

``` bash
python grace.py --dataset Cora --net PropChebNetII --hidden 64 --dropout 0.6 --K 10 --dprate 0.0 --tau 1.0 --proj_hid_dim=128 --patience 50 --unsup_epochs 1000 --lr1 0.01 --wd1 0.0 
```

Similarly, for PROP-DGI, you can run with

``` bash
python dgi.py --dataset Cora --net PropChebNetII  --hidden 64 --dropout 0.6 --K 2 --dprate 0.0 --patience 50 --unsup_epochs 1000 --lr1 0.01 --wd1 0.0
```
