# FixPO

A full repo will be made available in the future with easier install instructions.

## Setup Instructions

Install Python >=3.8

Install Python's poetry dependency manager:

```
curl -sSL https://install.python-poetry.org | python3 -
```

Install Mujoco 2.1:

```
mkdir -p $HOME/.mujoco && \
curl -O https://mujoco.org/download/mujoco210-linux-x86_64.tar.gz && \
tar xf mujoco210-linux-x86_64.tar.gz --directory $HOME/.mujoco

echo 'export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin' >> ~/.bashrc
source ~/.bashrc
```

Install dependencies:

```
pip install --upgrade --user pip
poetry install
```

Alternatively, use `install.sh`.

You will need also need to download `tianshou v0.5.0`, `Meta-World v2.0.0`, and
`trust-region-layers` and apply the provided patch files to them to run
Meta-World experiments.

Most experiments are listed in `exps.py` and use code in `src`.

To run those experiments:

```
poetry run python src/doexp.py exps_tianshou.py
```

## File Overview

`exps.py`: Defines all of the experiments to run.

`src/doexp.py`: Runs all experiments defined in `exps.py`


`src/fixpo_tianshou.py`: Main algorithm code.

`src/mujoco_fixpo_tianshou.py`: Launcher for FixPO with Gym environments.

`src/metaworld_fixpo_tianshou.py`: Launcher for FixPO with Meta-World environments.

`src/mujoco_ppo_tianshou.py`: Launcher for FixPO with Gym environments.

`src/metaworld_ppo_tianshou.py`: Launcher for FixPO with Meta-World environments.

`src/metaworld_utils.py`: Helper function for setting up Meta-World environments.

`src/metaworld_env_tianshou.py`: Helper function for setting up Meta-World environments.

`tianshou.patch`: Patch to Tianshou v0.5.0 that allows running Meta-World experiments.
`metaworld.patch`: Patch to Meta-World v2.0.0 that allows running Meta-World experiments.
`trust_region_layers.patch`: Patch to trust_region_layers that allows running Meta-World experiments.
`mujoco_kl_config.json`: Base config to use the KL projection proposed in  trust_region_layers.
