import yaml
import random
import os

def generate_random_configurations(num_configs, input_dim):
    hdim_choices = [64, 128, 256]  # Choices for mlp_hdim and phi_hdim
    layer_choices = [2, 3, 4]  # Choices for mlp_layers and phi_layers

    configurations = {}

    for _ in range(num_configs):
        # Randomly select parameters for decoder
        mlp_hdim = random.choice(hdim_choices)
        phi_hdim = random.choice(hdim_choices)
        mlp_layers = random.choice(layer_choices)
        phi_layers = random.choice(layer_choices)


        # Create the configuration key
        
        config_key = f"sum10d_encoder_depth{mlp_layers}_hd{mlp_hdim}_od64_proc_depth2_ed64_hd256_od25_decode_ed32_mlp{mlp_hdim}_mlpout16_mlplayers{mlp_layers}_phi{phi_hdim}_phiout{input_dim+1}_philayers{phi_layers}"
        # Create the configuration dictionary
        configurations[config_key] = {
            'encoder_layer': 'MLP',
                'input_dim': input_dim,
                'encoder_depth': mlp_layers,
                'encoder_width': mlp_hdim,
                'encoder_output_dim': 10,

                'processor_path': '/data/oren/coreset/models/elliptical-50/ConvexHullNN/direction/depth-2-ed-64-hd-256-od-25/model1_10d/final_model.pt',
                'processor_layer': 'ConvexHullNN',
                'processor_configs':
                    {'depth': 2,
                    'embedding_dim': 64,
                    'hidden_dim': 256,
                    'input_dim': 10,
                    'output_dim': 25},

                
                'decoder_layer': 'PointEncoder',
                'decoder_configs':
                    {'input_dim': 10, # equal to number of output points or dimensionality of output pts?
                    'embed_dim': 32,
                    'mlp_hdim': mlp_hdim,
                    'mlp_out_dim': phi_hdim,
                    'mlp_layers': mlp_layers,
                    'phi_hdim': phi_hdim,
                    'phi_out_dim': input_dim + 1,
                    'phi_layers': phi_layers,
                    'batchnorm': False,
                    'mean': False,
                    'use_max': False,
                    'activation': 'nn.LeakyReLU'}
        }

    fp = os.path.join('model-configs', '3d_meb_random_configs.yml')
    with open(fp, 'w') as file:
        yaml.dump(configurations, file, default_flow_style=False)

generate_random_configurations(15, 3)
