import yaml
import random
import os

def generate_random_configurations(num_configs):
    powers_of_two = [2, 3, 4]
    output_dims = [6, 8, 12, 14, 16] 

    configurations = {}

    for _ in range(num_configs):
        depth = random.choice(powers_of_two)
        embedding_dim = random.choice(powers_of_two)
        hidden_dim = random.choice(powers_of_two)
        output_dim = random.choice(output_dims)

        # Create the configuration key
        
        config_key = f"depth-{depth}-ed-{embedding_dim}-hd-{hidden_dim}-od-{output_dim}"
        # Create the configuration dictionary
        configurations[config_key] = {
            'depth': depth,
            'embedding_dim': embedding_dim,
            'hidden_dim': hidden_dim,
            'input_dim': 2,
            'output_dim': output_dim
        }

    fp = os.path.join('model-configs', 'random_configs.yml')
    with open(fp, 'w') as file:
        yaml.dump(configurations, file, default_flow_style=False)

generate_random_configurations(25)
