#!/bin/bash
function parse_yaml {
   local prefix=$2
   local s='[[:space:]]*' w='[a-zA-Z0-9_]*' fs=$(echo @|tr @ '\034')
   sed -ne "s|^\($s\):|\1|" \
        -e "s|^\($s\)\($w\)$s:$s[\"']\(.*\)[\"']$s\$|\1$fs\2$fs\3|p" \
        -e "s|^\($s\)\($w\)$s:$s\(.*\)$s\$|\1$fs\2$fs\3|p"  $1 |
   awk -F$fs '{
      indent = length($1)/2;
      vname[indent] = $2;
      for (i in vname) {if (i > indent) {delete vname[i]}}
      if (length($3) > 0) {
         vn=""; for (i=0; i<indent; i++) {vn=(vn)(vname[i])("_")}
         printf("%s%s%s=\"%s\"\n", "'$prefix'",vn, $2, $3);
      }
   }'
}

echo "Experiment config: $1"
echo "Trial: $2"
# echo "processor_path: $processor_path"

eval $(parse_yaml $1)
echo "datafile: $datafile"
echo "Device: $device"
echo "EPD: $epd"

python train_mee.py --datafile $datafile \
--epochs $epochs \
--device $device \
--batch-size $batch_size \
--dataset-name $dataset_name \
--configs $configs \
--layer-type $layer_type \
--trial $2 \
--epd $epd \

python 2d_mee_eval.py --experiment $2 \
--model_specs $configs \
--device $device \