# Neural TLP
## Setup
The code as developed using the following main requirements:
* Python 3.7+
* Pytorch 1.4+

## Data

We provide the data generation code and evaluation seen in the Data Ablation section of our paper. The original CATER results can be similarly generated using this code. We will release code for the original CATER dataset and the vision based atomic events based on interest. For the MIMIC-III data, you must show proof that you have credentialed access before we share our processed data and code. 

### Generate CATER Data
To generate sample CATER events run the following file with these arguments
```shell script
cd src/datasets/cater
python generate.py --co_occurring_events $num_events_j --gen_path $save_dir --rule_len $max_rule_len_n --max_rules_beam $rules_per_len --train_samples $m
```

For example

```shell script
python generate.py --co_occurring_events 3 --gen_path ~/neural_tlp_data/ --rule_len 2 --max_rules_beam 10 --train_samples 1000
```

Here co_occurring_events are the number of rules selected per sample as labels, and from which the timeline is generated. This generation induces other valid rules, so the total number of labels per sample is lower bounded by co_occurring_events. 

max_rule_len_n generates rules up to that length, and rules_per_len rules are generated for each length up to max_rule_len_n. The union of these rules are was is sampled during the generation step.

In generate_scripts are sample use cases that were used in the original experiments. Those can be modified as necessary (just save paths) to reproduce the results. 

## Run TLP

Now that the data is generated you can run Neural TLP generally as follows
```shell script
cd ../../tasks
python task_2.py --test_gen --var_len --device $gpu_num --gen_path $save_dir --proj_interval 1 --val_interval 5 --gen_events $num_events_j --gen_len_beam $max_comb_search_c --gen_len_batch_size 64 --gen_samples $m --gen_rules_beam $rules_per_len  --gen_len $max_rule_len_n --epochs 100 --gen_epochs 1 --time_dim_quant 150 
```

Argument details can be found in ./config.py. Continuing off our last example

```shell script
python task_2.py --test_gen --var_len --gen_events 3 --device 0 --gen_path ~/neural_tlp_data/ --proj_interval 1 --val_interval 5 --gen_len_beam 100 --gen_len_batch_size 64 --gen_samples 1000 --gen_rules_beam 10  --gen_len 2 --epochs 100 --gen_epochs 1 --time_dim_quant 150 
```

Similar to the generation, the full scripts used in our results can be found in the ./ablations/generated/neural_tlp for argument details. Here you can also run the Temporal MAP baselines in ./ablations/generated/neural_map. 

In ./ablations/generated you will also find two helper python scripts parse_event_logs.py and parse_sample_logs.py to help parse the trial results of event_experiments_trials.sh and sample_experiments_trials respectively. Follow the instructions on top of the python scripts to extract the results.