#!/usr/bin/env python
# coding: utf-8

# In[ ]:


import numpy as np
import math
import copy
import time
import cvxopt
import matplotlib.patches as patch
import matplotlib.pyplot as plt


# In[ ]:


def Reward_func(distance):
    return 1/(distance + 0.001)


# In[ ]:


#record the intial state and intial type of object
class Target(object):

    def __init__(self, init_state, init_type, time_step):
        self.state = np.array(init_state)
        # the trajectory for target
        self.traj = [np.array(init_state)]
        # moving direction
        self.u = np.array([10.0, 0])
        # distance to the closest agent
        self.min_dist = math.inf   
        self.dist_hist =[]  
        # record reward
        self.reward_hist=[]
        # Type: for example, ‘polyline’ 'Random walk' and 'Adversarial'
        self.type=init_type
        self.time_step = time_step
        
        if init_type=='Polyline':
            # the number of lines in polyline
            self.n_lines=np.random.choice([1,2,4], 1, p=[1/3,1/3,1/3])[0]
        elif init_type=='Adversarial':
            self.n_adversarial_trigger = 0
            self.adversarial_trigger = -2000
            # the sense realm of target, for example, the self.sense=80 implies we can detect the agents with  80m
            self.sense=80
    
    def update_distance(self,agents):
        self.min_dist=min([np.linalg.norm( self.state - ag.state) for ag in agents])
        self.dist_hist.append(self.min_dist)
    
    def record_reward(self,agents):
        self.reward_hist.append(max([Reward_func(np.linalg.norm( self.state - ag.state)) for ag in agents]))


    def update_state(self,H,agents,t):
        '''
        Updates the state of the target
        :param t: Index of time step.
        :param H: Horizon.
        :return: None.
        '''
        if self.type=='Polyline':
            Gap=int((H/self.time_step)/self.n_lines)
            if int(t)==0:
                theta=np.random.rand()
                self.u=(5*np.random.rand()+5)*np.array([math.cos(2*theta*math.pi),math.sin(2*theta*math.pi)])
            if int(t)%Gap==0: # implies t from [0,H/self.time_step)
                theta=np.random.rand()
                self.u=(5*np.random.rand()+5)*np.array([math.cos(2*theta*math.pi),math.sin(2*theta*math.pi)])
        elif self.type=='Random':
            theta=np.random.rand()
            self.u=(5*np.random.rand()+5)*np.array([math.cos(2*theta*math.pi),math.sin(2*theta*math.pi)])
        elif self.type=='Adversarial':
            length=int(1/self.time_step)
            if t >= self.adversarial_trigger+length and self.min_dist <20: # update self.min_dist in every step
                self.adversarial_trigger =t
                self.n_adversarial_trigger += 1
                
            if self.adversarial_trigger <= t < self.adversarial_trigger+length:
                direction=np.zeros(2)
                accumulate=np.zeros(2)
                num=0
                for i in range(len(agents)):
                    accumulate+=agents[i].state-self.state
                    distance=np.linalg.norm(self.state -agents[i].state)
                    if distance<=self.sense:
                        direction+=agents[i].state-self.state
                        num+=1
                if num>0:
                    self.u=-15*direction/np.linalg.norm(direction)
                else:
                    self.u=-15*accumulate/np.linalg.norm(accumulate)
                
            else:
                theta=np.random.rand()
                self.u=(5*np.random.rand()+5)*np.array([math.cos(2*theta*math.pi),math.sin(2*theta*math.pi)])
        self.state =self.state+ self.u * self.time_step

