import pandas as pd
import numpy as np

N_SEEDS = 500

def compute_ci_using_bootstrap(data, confidence=0.95):
    n = len(data)
    means = []
    for _ in range(1000):
        sample = np.random.choice(data, size=n, replace=True)
        means.append(np.mean(sample))
    lower_bound = np.percentile(means, (1 - confidence) / 2 * 100)
    upper_bound = np.percentile(means, (1 + confidence) / 2 * 100)
    return lower_bound, upper_bound

for exp in ["exp1", "exp2", "exp12", "exp4"]:
    if exp == "exp1" or exp == "exp2" or exp == "exp12":
        raw_col = "fnr_or_raw_gap"
        fair_col =  "fnr_or_fair_gap"
    else:
        assert exp == "exp4"
        raw_col = "fnr_gap_raw"
        fair_col = "fnr_gap_fair"
    col_name = "fnr_or_rawMinusFair_gap" if exp == "exp1" or exp == "exp2" or exp == "exp12" else "fnr_or_raw_gap"
    for size in [300, 1000, 3000, 10000, 30000, 100000, 300000]: 
        total = 0
        results = []
        for seed in range(N_SEEDS):
            data = pd.read_csv(f"/data/home/eilamshapira/FairnessUnderCompetition/results/{exp}_size{size}_seed{seed}.csv")
            results.append((np.abs(data[raw_col]) < np.abs(data[fair_col])).item())
        results = np.array(results)
        results_ci = compute_ci_using_bootstrap(results)
        print(f"exp: {exp}, size: {size} total: {results.mean():.1%}  [{results_ci[0]:.1%}, {results_ci[1]:.1%}] ({sum(results)}/{N_SEEDS})")
