#!/bin/bash

# Check if Conda is installed; if not, download and install Miniconda
if ! command -v conda &>/dev/null; then
    echo "🐍 Conda not found. Installing Miniconda..."
    wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh
    bash Miniconda3-latest-Linux-x86_64.sh -b
    # Load Conda into the current shell session
    source "$HOME/miniconda3/etc/profile.d/conda.sh"
    echo "source $HOME/miniconda3/etc/profile.d/conda.sh" >> ~/.bashrc
    conda init
    echo "✅ Miniconda installation complete."
else
    echo "🐍 Conda is already installed. Proceeding..."
fi

# Define environment name and Python version
ENV_NAME="fairness"
PYTHON_VERSION="3.11"

# Check if the Conda environment already exists
if conda info --envs | grep -q "^$ENV_NAME"; then
    echo "🐍 Conda environment '$ENV_NAME' already exists. Skipping creation."
else
    # Create the Conda environment
    echo "🐍 Creating Conda environment: $ENV_NAME with Python $PYTHON_VERSION"
    conda create -y -n $ENV_NAME python=$PYTHON_VERSION
fi

# Activate the environment
echo "🚀 Activating environment: $ENV_NAME"
source "$(conda info --base)/etc/profile.d/conda.sh"
conda activate $ENV_NAME

# Installing uv
if ! command -v uv &>/dev/null; then
    echo "📦 Installing uv"
    pip install uv
else
    echo "📦 uv is already installed. Skipping."
fi

# Install dependencies using uv
echo "📄 Installing dependencies from requirements.txt using uv"
uv pip install -r requirements.txt

echo "🎉 Environment setup completed! To activate, use: conda activate $ENV_NAME"
