cat imagenet_mobile.sh

export CUDA_VISIBLE_DEVICES=0,1,2,3;
python -m pdb main.py \
    --dataset imagenet \
    --model mobilenetV2 \
    --optimizer momentum \
    --train-batch-size 256 \
    --prune-batch-size 128 \
    --post-epochs 0 \
    --lr 0.025 \
    --lr-scheduler drop \
    --lr-step-size 1 \
    --lr-drop-rate 0.98 \
    --pruner opt_both \
    --mask-scope precropping \
    --compression 0.6 \
    --compression-flops 1 \
    --expand \
    --weight-decay 4e-5 \
    --prune-epochs 10 \
    --expid imagenet_mobilenet_preconfig \
    --data-dir {PATH_TO_DATA} \
    --width-factor 1 \
    --print-model \
    --parallel \
    --verbose \
    --prune-pw-only \
    --workers 20

# pruner = {synflow, opt_flops, opt_params, opt_both}
# scope = {global, filter, precropping}
# use the argument `compression-flops` to specify the flops pruning ratio when using scope OptBoth
