cat imagenet_res.sh

export CUDA_VISIBLE_DEVICES=0,1,2,3;
python -m pdb main.py \
    --dataset imagenet \
    --model resnet34 \
    --optimizer momentum \
    --train-batch-size 512 \
    --post-epochs 90 \
    --lr 0.2 \
    --lr-scheduler drop \
    --lr-drops 30 60 \
    --pruner opt_both \
    --mask-scope precropping \
    --compression 0.8 \
    --compression-flops 0.9 \
    --expand \
    --weight-decay 1e-4 \
    --width-factor 1 \
    --prune-epochs 0 \
    --expid imagenet_resnet34_preconfig \
    --data-dir {PATH_TO_DATA} \
    --print-model \
    --parallel \
    --verbose \
    --workers 20

# pruner = {synflow, opt_flops, opt_params, opt_both}
# scope = {global, filter, precropping}
# use the argument `compression-flops` to specify the flops pruning ratio when using scope OptBoth
