#  Copyright (c) 2024, Salesforce, Inc.
#  SPDX-License-Identifier: Apache-2
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from ._base import LOTSADatasetBuilder
# from .simple import SimpleDatasetBuilder
from .buildings_bench import Buildings900KDatasetBuilder, BuildingsBenchDatasetBuilder
from .cloudops_tsf import CloudOpsTSFDatasetBuilder
from .cmip6 import CMIP6DatasetBuilder
from .era5 import ERA5DatasetBuilder
from .gluonts import GluonTSDatasetBuilder
from .largest import LargeSTDatasetBuilder
from .lib_city import LibCityDatasetBuilder
from .others import OthersLOTSADatasetBuilder
from .proenfo import ProEnFoDatasetBuilder
from .subseasonal import SubseasonalDatasetBuilder
from .synthetic import *

__all__ = [
    "LOTSADatasetBuilder",
    "Buildings900KDatasetBuilder",
    "BuildingsBenchDatasetBuilder",
    "CloudOpsTSFDatasetBuilder",
    "CMIP6DatasetBuilder",
    "ERA5DatasetBuilder",
    "GluonTSDatasetBuilder",
    "LargeSTDatasetBuilder",
    "LibCityDatasetBuilder",
    "OthersLOTSADatasetBuilder",
    "ProEnFoDatasetBuilder",
    "SubseasonalDatasetBuilder",
    "SimpleDatasetBuilder",
    "Seasonal100_Lag5DatasetBuilder",
    "Seasonal50_Lag5DatasetBuilder",
    "Synthetic100_Lag5DatasetBuilder",
    "Synthetic50_Lag5DatasetBuilder",
    "SeasonalTest_Lag5DatasetBuilder",
    "SyntheticTest_Lag5DatasetBuilder",
    "SyntheticMixedDatasetBuilder",
    "SeasonalityMixedDatasetBuilder",
    "SyntheticMixed2DatasetBuilder",
    "StrongDatasetBuilder"
]

for i in range(10, 110, 10):
    __all__.append(f"SyntheticD{i}DatasetBuilder")
