# Atom Thinking Of LLMs
We provide the data and code used in our exploration of LLM mathematical atomic capabilities for review at NeurIPS2025. The following is an introduction to the use of our data and code:

## Data
The data corresponding to each atomic capability can be found in the *`sample_submit_data`* folder, where the data related to the field atomic capability is placed in the *`field`* folder, and the data related to the logic atomic capability is placed in the *`logic`* folder. In order to facilitate the review and protect the validity of our data, we randomly sampled 300 pieces from all the test data for each atomic capability for review. We promise we will further improve the open source of data in the subsequent open source of our data and code in HuggingFace and GitHub, and better restrict the use of data.

All data are stored in JSONL format, including `"question", "final_answer", "solution"` content (there is no corresponding solution in the concept understanding).

## Code
We provide the code used to evaluate each atomic capability and its related prompts in the *`experimental`* folder.
### Open-source Model
Modify the input prompt and corresponding input data, model used and other parameters, and run the script:
```
bash eval.sh
```
You can get the corresponding evaluation results.

### Closed-source Model
Modify the corresponding API KEY and API URL, and run the code to call the API:
```
python API_call.py
```
