import base64
import requests
import json
import re
import random
import argparse
import torch
import os
from transformers import AutoTokenizer
from tqdm import tqdm

API_URL = "API_URL"
API_KEY = "API_KEY"

headers = {
    "Content-Type": "application/json",
    "Authorization": f"Bearer {API_KEY}"
}

def extract_answer(text):
    pattern = r'\\boxed\{(.*?)\}'
    match = re.search(pattern, text, re.DOTALL)
    return match.group(1).strip() if match else ''

instr = "Please think step by step to fill in the blank in '''  ''' of following statement, and put your final answer in \\boxed{}."

def model_call(input_data, output_file='FILEPATH'):
    for item in tqdm(input_data, desc="Processing items", total=len(input_data)):
        prompt = (
            "Question:\n"
            f"{item['question']}"
        )

        try:
            response = requests.post(API_URL, headers=headers, json={
                "model": "model-name",
                "messages": [{"role": "system", "content": instr}, {"role": "user", "content": prompt}],
                "max_tokens": 2048,
                "temperature": 0.7,
            })

            if response.status_code == 200:
                result = response.json()
                response_content = result['choices'][0]['message']['content'].strip()
                extracted_answer = extract_answer(response_content)

                usage_info = result.get('usage', {})
                used_tokens = usage_info.get('total_tokens', 'unknown')

                output_entry = {
                    "model_output": response_content,
                    "prediction": extracted_answer,
                    "answer": item['final_answer'],
                    "solution": item['solution'],
                    "used_tokens": used_tokens
                }

                with open(output_file, 'a', encoding='utf-8') as f:
                    f.write(json.dumps(output_entry, ensure_ascii=False) + '\n')
            else:
                print(f"Error: {response.status_code}, {response.text}")

        except Exception as e:
            print(f"Exception occurred for item: {item.get('question', '')}")
            print(e)

if __name__ == "__main__":
    input_path = 'DATA_FILE_PATH'
    output_path = 'OUTPUT_FILE_PATH'

    with open(input_path, 'r', encoding='utf-8') as f:
        data = [json.loads(line.strip()) for line in f.readlines()]

    model_call(data, output_path)