#!/bin/bash
source $(conda info --base)/etc/profile.d/conda.sh
conda activate env1
set -e
export OPENAI_API_KEY=""
export WANDB_API_KEY=""
export num_samples=3000

/opt/miniconda3/envs/env1/bin/python3.13 generate_dataset.py \
    --model_name_or_path "o4-mini" \
    --api_key "$OPENAI_API_KEY" \
    --prompt_file "./prompts/generation.json" \
    --prompt_id "alist_from_nl" \
    --num_samples $num_samples \
    --dataset_path "./data/maths" \
    --batched_generation True \
    --output_dir "./experiments/output" \
    --wandb_project "dataset_generation" \
    --wandb_run_name "alist-from-maths-dataset" \