#!/usr/bin/env python3

from pathlib import Path

BASE_DIR = Path('.')
DATA_DIR = BASE_DIR / 'vectors' / 'raw'
RESULTS_DIR = BASE_DIR / 'results'
FIGURES_DIR = BASE_DIR / 'figures'

MODELS = ['gemma', 'llama3', 'mistral']

TRAITS = [
    'accessibility', 'assertiveness', 'authority', 'certainty', 'clarity',
    'concreteness', 'creativity', 'directness', 'emotional_tone', 'empathy',
    'enthusiasm', 'formality', 'hedging', 'humor', 'inclusivity',
    'objectivity', 'optimism', 'persuasiveness', 'politeness', 'precision',
    'professionalism', 'register', 'specificity', 'technical_complexity',
    'urgency', 'verbosity'
]

HF_TRAITS = [
    'accessibility', 'assertiveness', 'authority', 'clarity', 'directness',
    'emotional_tone', 'enthusiasm', 'formality', 'inclusivity', 'objectivity',
    'optimism', 'professionalism', 'register', 'specificity', 'verbosity'
]

K_DIMS = 1300
SEED = 42
TRAIN_SPLIT = 0.8
MAX_VECTORS_PER_TRAIT = 2500

MODEL_PAIRS = [
    ('gemma', 'llama3'),
    ('gemma', 'mistral'),
    ('llama3', 'gemma'),
    ('llama3', 'mistral'),
    ('mistral', 'gemma'),
    ('mistral', 'llama3')
]