#!/bin/bash

set -x

# real file path of current script
workfile="$(realpath "$0")"

cd ..
__ScriptVersion="1.0"
__BaseName=$(basename "$0")

#===  FUNCTION  ================================================================
#         NAME:  usage
#  DESCRIPTION:  Display usage information.
#===============================================================================
function usage ()
{
    echo "Usage :  $__BaseName task_name

    Options:
    -h|help       Display this message
    -v|version    Display script version
    
    tasks=(cola sst2 mrpc qqp stsb mnli qnli rte wnli)

    Examples:"

}    # ----------  end of function usage  ----------

#-----------------------------------------------------------------------
#  Handle command line arguments
#-----------------------------------------------------------------------

while getopts ":hv" opt
do
  case $opt in

    h|help     )  usage; exit 0   ;;

    v|version  )  echo "$__BaseName -- Version $__ScriptVersion"; exit 0   ;;
    
    * )  echo -e "\n  Option does not exist : $OPTARG\n"
          usage; exit 1   ;;

  esac    # --- end of case ---
done
shift $(($OPTIND-1))

interval=100000000
max_seq_length=512
num_train_epochs=30
function switch_lora() {
    origin_output_dir="./glue_output/$1.lr/"
    output_dir="$origin_output_dir"
    # Detect whether output_dir exists, if so, let output_dir=output_dir((i+1)) where i starts from 0
    i=0
    while [ -d "$output_dir" ]; do
        i=$((i+1))
        output_dir="$origin_output_dir""$i"
    done

    echo "************************************************************"
    echo "*** output to $output_dir **********************************"
    echo "************************************************************"

    ./run_glue.sh --switch_lora "$1" "roberta-base" \
    --output_dir "$output_dir" \
    --max_seq_length "$max_seq_length" \
    --num_train_epochs "$num_train_epochs" \
    --per_device_train_batch_size "$2" \
    --learning_rate "$3" \
    --switch_lora_descent_rate 0.1 \
    --switch_lora_interval "$4" \
    --scheduler linear \
    --lora_dropout 0.1 \
    --lora_rank "$5"
    rm -rf "$output_dir"
}
function switch_lora_rank4() {
    switch_lora "$@" 4
}

export HF_HUB_OFFLINE=1 && export WANDB_MODE=offline && export HF_DATASETS_OFFLINE=1
# Array of GLUE tasks
tasks=("cola" "sst2" "mrpc" "qqp" "stsb" "mnli" "qnli" "rte" "wnli")

output_file="./glue_output/$1.lr$2.txt"
git log > "$output_file"
git diff >> "$output_file"
cat "$workfile" >> "$output_file"
echo "*****************************************" >> "$output_file"
echo "*****************************************" >> "$output_file"
# learning_rate loop from 1e-5 to 9e-5 and switch_lora_interval from 20 to 320
for lr in 3e-5 6e-5 1e-4 2e-4 4e-4 8e-4; do
    # Loop over switch_lora_interval values from 10 to 100 with an increment of 10
    for i in 1 2; do
        switch_lora_rank4 "$1" 16 "$lr" "$interval" | tee -a "$output_file"
    done
done
