import matplotlib.pyplot as plt
import matplotlib as mpl
import math
mpl.rcParams['text.usetex'] = True
def set_font_size():
    SMALL_SIZE = 12
    MEDIUM_SIZE = 14
    BIGGER_SIZE = 16

    # plt.rc('font', size=SMALL_SIZE)  # controls default text sizes
    plt.rc('axes', titlesize=BIGGER_SIZE)  # fontsize of the axes title
    plt.rc('axes', labelsize=MEDIUM_SIZE)  # fontsize of the x and y labels
    plt.rc('xtick', labelsize=SMALL_SIZE)  # fontsize of the tick labels
    plt.rc('ytick', labelsize=SMALL_SIZE)  # fontsize of the tick labels
    plt.rc('legend', fontsize=MEDIUM_SIZE)  # legend fontsize
    plt.rc('figure', titlesize=BIGGER_SIZE)  # fontsize of the figure title


set_font_size()

# Sample data: each element is a tuple (interval, ratio, ppl)
data = [
    (40, 0.1, 3.6425652503967285),
    (10, 0.1, 3.6652369499206543),
    (160, 0.1, 3.6737897396087646),
    (40, 0.5, 3.6979167461395264),
    (40, 0.02, 3.6886234283447266),
    (20, 0.05, 3.6822917461395264),
    (80, 0.2, 3.657271146774292),
    (320, 0.4, 3.6882660388946533),
]
text_right = (0, 4, 3)

# Unpacking the data
intervals = [d[0] for d in data]
ratios = [d[1] for d in data]
ppls = [math.exp(d[2]*2.5) for d in data]
max_ppl = max(ppls)
min_ppl = min(ppls)
ppls = [ppl - min_ppl + (max_ppl - min_ppl)/2 for ppl in ppls]

# Adjusting the size of each point
# You may want to scale the sizes or use them directly depending on your data
sizes = [ppl * 0.2 for ppl in ppls]  # Scale the 'ppl' values to adjust point sizes

# Creating the scatter plot
plt.scatter(intervals, ratios, s=sizes, alpha=0.5, color='dodgerblue')  # Adjust alpha for better visualization

i = 0
for interval, ratio, ppl in data:
    if i == 0:
        plt.scatter(intervals[:1], ratios[:1], s=[sizes[0]*1.8], facecolors='none', edgecolors='r')  # Adjust alpha for better visualization
    if i in text_right:
        plt.annotate(f'({interval}, {ratio}, {math.exp(ppl):.1f})', 
                     (interval, ratio), 
                     textcoords="offset points", 
                     xytext=(43,-3), 
                     ha='center')
    else:
        plt.annotate(f'({interval}, {ratio}, {math.exp(ppl):.1f})', 
                     (interval, ratio), 
                     textcoords="offset points", 
                     xytext=(0,10), 
                     ha='center')
    i += 1

# Adding titles and labels
# plt.title('Plot of Ratio vs Interval')
plt.xlabel(r'$interval_{0}$')
plt.ylabel(r'$ratio$')

# Optional: Adding a color bar if needed
# plt.colorbar()  # Uncomment this line if size color mapping is important

# Show the plot
# plt.show()
save_path='llama130m_interval_ratio_scatter.png'
plt.savefig(save_path, bbox_inches='tight')

