#!/bin/bash
set -x

__ScriptVersion="1.0"
__BaseName=$(basename "$0")

#===  FUNCTION  ================================================================
#         NAME:  usage
#  DESCRIPTION:  Display usage information.
#===============================================================================
function usage ()
{
    echo "Usage :  $__BaseName [options] [--]

    Options:
    -h|help       Display this message
    -v|version    Display script version
    

    Examples:"

}    # ----------  end of function usage  ----------


export HF_HUB_OFFLINE=1 && export WANDB_MODE=offline && export HF_DATASETS_OFFLINE=1

if [[ "$1" = "--use_lora" ]]; then
    switch_lora=false
    use_lora=true
    other_params=( --use_lora --lora_rank 8 --lora_dropout 0.1)
elif [[ "$1" = "--switch_lora" ]]; then
    switch_lora=false
    use_lora=true
    other_params=( --switch_lora --adam_warm_step 5 --zero_switch_state --zero_switch_step_state)
else
    switch_lora=false
    use_lora=false
fi
task="$2"
model_name_or_path="$3"

shift 3

# generate random int seed
seed=$(od -vAn -N4 -tu4 < /dev/urandom)
echo "seed: $seed"

# Loop through each task
echo "Running task: $task"
python run_glue.py \
--model_name_or_path "$model_name_or_path" \
--task_name "$task" \
--use_llama False \
--do_train \
--do_eval \
--evaluation_strategy epoch \
--save_total_limit 2 \
--save_safetensors False \
--save_steps 1000000 \
--overwrite_output_dir \
--fp16 \
--cache_dir ./glue \
--seed "$seed" \
"$@" "${other_params[@]}"

