import uuid
import itertools
from pycondor.pycondor import *
import numpy as np

if __name__ == '__main__':
    seeds = [0]
    lrs = np.logspace(-10, 5, num=31)[::-1] #sgd
    
    depth_mults = [1]
    width_mults = [8]
    layers_per_blocks = [1]
    temperatures = [1]
    gamma0 = np.logspace(-5, 5, 21)[::-1]
    params = ['mup_sqrt_depth']
    for run in itertools.product(*[width_mults, depth_mults, seeds, lrs, params, layers_per_blocks, gamma0, temperatures]):
        uid = uuid.uuid4().hex[:10]
        arguments = f"{run[0]} {run[1]} {run[2]} {run[3]} {run[4]} {run[5]} {run[6]} {run[7]}"
        output = f"runs/{uid}.stdout"
        error = f"runs/{uid}.stderr"
        log = f"runs/{uid}.log"
        cpus = 17
        gpus = 1
        memory = 62000
        disk = "1G"
        executable = "run_training.sh"

        try:
            content = make_submisison_file_content(executable, arguments, output, error, log, cpus, gpus, memory, disk)
            run_job(uid, 100, content)
        except:
            raise ValueError("Crashed.")
    print("Done.")