#!/bin/sh

python dpi_gauss.py \
    --score_model_config score_configs/default_ncsnpp_config.py \
    --config dpi_configs/default_config.py \
    --workdir dpi_gauss/LSUN_Deblurring \
    --config.prob_flow.score_model_dir score_checkpoints/LSUN_256_ncsnpp_nf=64_vpsde_betamin=0.1_betamax=20.0_notcentered/checkpoints/checkpoint_550000 \
    --config.data.dataset LSUN \
    --config.data.image_size 256 \
    --config.data.num_channels 3 \
    --config.data.tfds_dir ~/tensorflow_datasets \
    --config.data.shuffle_seed 6 \
    --config.likelihood.likelihood Deblurring \
    --config.likelihood.n_dft 64 \
    --config.likelihood.noise_scale 1. \
    --config.training.batch_size 32 \
    --config.training.n_iters 500000 \
    --config.training.snapshot_freq 5000 \
    --config.training.log_freq 100 \
    --config.optim.learning_rate 1e-5 \
    --config.optim.grad_clip 2e-4 \
    --config.optim.prior dsm \
    --score_model_config.training.sde vpsde \
    --score_model_config.model.beta_max 20