#!/bin/sh

# Run from main directory: `sh scripts/train.sh`

python train.py \
    --config score_configs/default_ncsnpp_config.py \
    --workdir score_checkpoints \
    --config.data.dataset CelebAHQ \
    --config.data.image_size 256 \
    --config.data.num_channels 3 \
    --config.data.tfds_dir /tmp/bfeng/tensorflow_datasets/celebahq_256 \
    --config.training.sde vpsde \
    --config.training.smallest_time 1e-3 \
    --config.model.beta_min 0.1 \
    --config.model.beta_max 20 \
    --config.training.n_jitted_steps 5 \
    --config.training.batch_size 32 \
    --config.eval.batch_size 8 \
    --config.training.n_iters 2000000 \
    --config.training.snapshot_freq 50000 \
    --config.training.log_freq 1000 \
    --config.optim.warmup 5000
